require("dotenv").config();
const express = require("express");
const cors = require("cors");
const mongoose = require("mongoose");

const app = express();

app.use(cors());
app.use(express.json());

// Database Connection
mongoose.connect(process.env.MONGO_URI)
    .then(() => {
        console.log("Database Connected Successfully");
    })
    .catch((error) => {
        console.log(error);
    });

// Starting Routes
app.get("/", (req, res) => {
    res.send("Server is running");
});

// Routes
app.use("/api/auth", require('./routes/auth'));
app.use("/api/leave", require('./routes/leave'));

// Start Server
app.listen(process.env.PORT, () => {
    console.log(`Server is running on port ${process.env.PORT}`);
});

